/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.server;

import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyStore;
import java.util.Set;
import org.eclipse.jetty.quic.common.QuicConfiguration;
import org.eclipse.jetty.quic.quiche.PemExporter;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerQuicConfiguration
extends QuicConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(ServerQuicConfiguration.class);
    private final SslContextFactory.Server sslContextFactory;

    public ServerQuicConfiguration(SslContextFactory.Server sslContextFactory, Path pemWorkDirectory) {
        this.sslContextFactory = sslContextFactory;
        this.setPemWorkDirectory(pemWorkDirectory);
        this.setSessionRecvWindow(0x400000);
        this.setBidirectionalStreamRecvWindow(0x200000);
        this.setMaxBidirectionalRemoteStreams(1);
        this.setMaxUnidirectionalRemoteStreams(0);
    }

    public SslContextFactory.Server getSslContextFactory() {
        return this.sslContextFactory;
    }

    protected void doStart() throws Exception {
        String keyManagerPassword;
        this.addBean(this.sslContextFactory);
        super.doStart();
        Path pemWorkDirectory = this.getPemWorkDirectory();
        Set aliases = this.sslContextFactory.getAliases();
        if (aliases.isEmpty()) {
            throw new IllegalStateException("Missing or invalid KeyStore: a SslContextFactory configured with a valid, non-empty KeyStore is required");
        }
        String alias = this.sslContextFactory.getCertAlias();
        if (alias == null) {
            alias = (String)aliases.stream().findFirst().orElseThrow();
        }
        char[] password = (keyManagerPassword = this.sslContextFactory.getKeyManagerPassword()) == null ? this.sslContextFactory.getKeyStorePassword().toCharArray() : keyManagerPassword.toCharArray();
        KeyStore keyStore = this.sslContextFactory.getKeyStore();
        Path[] keyPair = PemExporter.exportKeyPair((KeyStore)keyStore, (String)alias, (char[])password, (Path)pemWorkDirectory);
        Path privateKeyPemPath = keyPair[0];
        this.getImplementationConfiguration().put(PRIVATE_KEY_PEM_PATH_KEY, privateKeyPemPath);
        Path certificateChainPemPath = keyPair[1];
        this.getImplementationConfiguration().put(CERTIFICATE_CHAIN_PEM_PATH_KEY, certificateChainPemPath);
        KeyStore trustStore = this.sslContextFactory.getTrustStore();
        if (trustStore != null) {
            Path trustedCertificatesPemPath = PemExporter.exportTrustStore((KeyStore)trustStore, (Path)pemWorkDirectory);
            this.getImplementationConfiguration().put(TRUSTED_CERTIFICATES_PEM_PATH_KEY, trustedCertificatesPemPath);
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        Path trustedCertificatesPemPath = (Path)this.getImplementationConfiguration().remove(TRUSTED_CERTIFICATES_PEM_PATH_KEY);
        this.deleteFile(trustedCertificatesPemPath);
        Path certificateChainPemPath = (Path)this.getImplementationConfiguration().remove(CERTIFICATE_CHAIN_PEM_PATH_KEY);
        this.deleteFile(certificateChainPemPath);
        Path privateKeyPemPath = (Path)this.getImplementationConfiguration().remove(PRIVATE_KEY_PEM_PATH_KEY);
        this.deleteFile(privateKeyPemPath);
    }

    private void deleteFile(Path path) {
        block3: {
            try {
                if (path != null) {
                    Files.delete(path);
                }
            }
            catch (Throwable x) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("could not delete {}", (Object)path, (Object)x);
            }
        }
    }
}

