/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche.foreign;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.foreign.AddressLayout;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.jetty.util.IO;

public class NativeHelper {
    public static final ValueLayout.OfByte C_BOOL;
    public static final ValueLayout.OfByte C_CHAR;
    public static final ValueLayout.OfShort C_SHORT;
    public static final ValueLayout.OfInt C_INT;
    public static final ValueLayout.OfLong C_LONG_LONG;
    public static final ValueLayout.OfFloat C_FLOAT;
    public static final ValueLayout.OfDouble C_DOUBLE;
    public static final AddressLayout C_POINTER;
    public static final ValueLayout.OfLong C_LONG;
    private static final SymbolLookup SYMBOL_LOOKUP;
    private static final Platform PLATFORM;

    private static void loadNativeLibraryFromClasspath(String prefix) {
        try {
            String libName = prefix + "/" + System.mapLibraryName("quiche");
            Path lib = NativeHelper.extractFromResourcePath(libName, NativeHelper.class.getClassLoader());
            System.load(lib.toAbsolutePath().toString());
            lib.toFile().deleteOnExit();
        }
        catch (Throwable x) {
            throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("Cannot find quiche native library for architecture " + prefix).initCause(x);
        }
    }

    private static Path extractFromResourcePath(String libName, ClassLoader classLoader) throws IOException {
        Path target = Path.of(System.getProperty("java.io.tmpdir"), new String[0]).resolve(libName);
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        try (InputStream is = classLoader.getResourceAsStream(libName);
             OutputStream os = Files.newOutputStream(target, new OpenOption[0]);){
            IO.copy((InputStream)is, (OutputStream)os);
        }
        return target;
    }

    public static MethodHandle downcallHandle(String symbol, FunctionDescriptor fdesc) {
        return Linker.nativeLinker().downcallHandle(SYMBOL_LOOKUP.find(symbol).orElseThrow(() -> new UnsatisfiedLinkError("unresolved symbol: " + symbol)), fdesc, new Linker.Option[0]);
    }

    public static <T> MemorySegment upcallMemorySegment(Class<T> clazz, String methodName, T instance, FunctionDescriptor fdesc, Arena scope) {
        try {
            MethodHandle handle = MethodHandles.lookup().findVirtual(clazz, methodName, fdesc.toMethodType());
            handle = handle.bindTo(instance);
            return Linker.nativeLinker().upcallStub(handle, fdesc, scope, new Linker.Option[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static boolean isLinux() {
        return PLATFORM == Platform.LINUX;
    }

    public static boolean isMac() {
        return PLATFORM == Platform.MAC;
    }

    public static boolean isWindows() {
        return PLATFORM == Platform.WINDOWS;
    }

    static {
        String prefix;
        String osName;
        C_BOOL = ValueLayout.JAVA_BYTE;
        C_CHAR = ValueLayout.JAVA_BYTE;
        C_SHORT = ValueLayout.JAVA_SHORT;
        C_INT = ValueLayout.JAVA_INT;
        C_LONG_LONG = ValueLayout.JAVA_LONG;
        C_FLOAT = ValueLayout.JAVA_FLOAT;
        C_DOUBLE = ValueLayout.JAVA_DOUBLE;
        C_POINTER = ValueLayout.ADDRESS.withTargetLayout(MemoryLayout.sequenceLayout(Long.MAX_VALUE, ValueLayout.JAVA_BYTE));
        C_LONG = ValueLayout.JAVA_LONG;
        SYMBOL_LOOKUP = SymbolLookup.loaderLookup().or(Linker.nativeLinker().defaultLookup());
        String arch = System.getProperty("os.arch");
        if ("x86_64".equals(arch) || "amd64".equals(arch)) {
            arch = "x86-64";
        }
        if ((osName = System.getProperty("os.name")).startsWith("Linux")) {
            prefix = "linux-" + arch;
            PLATFORM = Platform.LINUX;
        } else if (osName.startsWith("Mac") || osName.startsWith("Darwin")) {
            prefix = "darwin-" + arch;
            PLATFORM = Platform.MAC;
        } else if (osName.startsWith("Windows")) {
            prefix = "win32-" + arch;
            PLATFORM = Platform.WINDOWS;
        } else {
            throw new UnsatisfiedLinkError("Unsupported OS: " + osName);
        }
        NativeHelper.loadNativeLibraryFromClasspath(prefix);
    }

    private static enum Platform {
        LINUX,
        MAC,
        WINDOWS;

    }
}

