/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.security.jaspi.provider;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.config.ServerAuthConfig;
import jakarta.security.auth.message.config.ServerAuthContext;
import jakarta.security.auth.message.module.ServerAuthModule;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.eclipse.jetty.ee10.security.jaspi.provider.SimpleServerAuthContext;

class SimpleAuthConfig
implements ServerAuthConfig {
    private final String _messageLayer;
    private final String _appContext;
    private final CallbackHandler _callbackHandler;
    private final Map _properties;
    private final ServerAuthModule _serverAuthModule;

    public SimpleAuthConfig(String messageLayer, String appContext, CallbackHandler callbackHandler, Map properties, ServerAuthModule serverAuthModule) {
        this._messageLayer = messageLayer;
        this._appContext = appContext;
        this._callbackHandler = callbackHandler;
        this._properties = properties;
        this._serverAuthModule = serverAuthModule;
    }

    public ServerAuthContext getAuthContext(String authContextID, Subject serviceSubject, Map properties) throws AuthException {
        return new SimpleServerAuthContext(this._callbackHandler, this._serverAuthModule, this._properties);
    }

    public String getAppContext() {
        return this._appContext;
    }

    public String getAuthContextID(MessageInfo messageInfo) {
        return null;
    }

    public String getMessageLayer() {
        return this._messageLayer;
    }

    public boolean isProtected() {
        return true;
    }

    public void refresh() {
    }
}

