/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.server;

import org.eclipse.jetty.fcgi.server.internal.ServerFCGIConnection;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject
public class ServerFCGIConnectionFactory
extends AbstractConnectionFactory {
    private final HttpConfiguration configuration;
    private final boolean sendStatus200;
    private boolean useInputDirectByteBuffers;
    private boolean useOutputDirectByteBuffers;

    public ServerFCGIConnectionFactory(HttpConfiguration configuration) {
        this(configuration, true);
    }

    public ServerFCGIConnectionFactory(HttpConfiguration configuration, boolean sendStatus200) {
        super("fcgi/1.0");
        this.configuration = configuration;
        this.sendStatus200 = sendStatus200;
        this.setUseInputDirectByteBuffers(configuration.isUseInputDirectByteBuffers());
        this.setUseOutputDirectByteBuffers(configuration.isUseOutputDirectByteBuffers());
    }

    @ManagedAttribute(value="Whether to use direct ByteBuffers for reading")
    public boolean isUseInputDirectByteBuffers() {
        return this.useInputDirectByteBuffers;
    }

    public void setUseInputDirectByteBuffers(boolean useInputDirectByteBuffers) {
        this.useInputDirectByteBuffers = useInputDirectByteBuffers;
    }

    @ManagedAttribute(value="Whether to use direct ByteBuffers for writing")
    public boolean isUseOutputDirectByteBuffers() {
        return this.useOutputDirectByteBuffers;
    }

    public void setUseOutputDirectByteBuffers(boolean useOutputDirectByteBuffers) {
        this.useOutputDirectByteBuffers = useOutputDirectByteBuffers;
    }

    public Connection newConnection(Connector connector, EndPoint endPoint) {
        ServerFCGIConnection connection = new ServerFCGIConnection(connector, endPoint, this.configuration, this.sendStatus200);
        connection.setUseInputDirectByteBuffers(this.isUseInputDirectByteBuffers());
        connection.setUseOutputDirectByteBuffers(this.isUseOutputDirectByteBuffers());
        return this.configure((AbstractConnection)connection, connector, endPoint);
    }
}

