/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.websocket.jakarta.common.messages;

import jakarta.websocket.CloseReason;
import jakarta.websocket.DecodeException;
import jakarta.websocket.Decoder;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.List;
import org.eclipse.jetty.ee9.websocket.jakarta.common.JakartaWebSocketFrameHandlerFactory;
import org.eclipse.jetty.ee9.websocket.jakarta.common.decoders.RegisteredDecoder;
import org.eclipse.jetty.ee9.websocket.jakarta.common.messages.AbstractDecodedMessageSink;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.exception.CloseException;
import org.eclipse.jetty.websocket.core.messages.InputStreamMessageSink;
import org.eclipse.jetty.websocket.core.messages.MessageSink;

public class DecodedBinaryStreamMessageSink<T>
extends AbstractDecodedMessageSink.Stream<Decoder.BinaryStream<T>> {
    public DecodedBinaryStreamMessageSink(CoreSession session, MethodHandle methodHandle, List<RegisteredDecoder> decoders) {
        super(session, methodHandle, decoders);
    }

    @Override
    MessageSink newMessageSink(CoreSession coreSession) throws Exception {
        MethodHandle methodHandle = JakartaWebSocketFrameHandlerFactory.getServerMethodHandleLookup().findVirtual(DecodedBinaryStreamMessageSink.class, "onStreamStart", MethodType.methodType(Void.TYPE, InputStream.class)).bindTo(this);
        return new InputStreamMessageSink(coreSession, methodHandle, true);
    }

    public void onStreamStart(InputStream stream) {
        try {
            Object obj = ((Decoder.BinaryStream)this._decoder).decode(stream);
            this.invoke(obj);
        }
        catch (DecodeException | IOException e) {
            throw new CloseException(CloseReason.CloseCodes.CANNOT_ACCEPT.getCode(), "Unable to decode", e);
        }
    }
}

