/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.generator;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.eclipse.jetty.http3.frames.Frame;
import org.eclipse.jetty.http3.frames.FrameType;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.http3.generator.FrameGenerator;
import org.eclipse.jetty.http3.internal.VarLenInt;
import org.eclipse.jetty.http3.qpack.QpackEncoder;
import org.eclipse.jetty.http3.qpack.QpackException;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;

public class HeadersGenerator
extends FrameGenerator {
    private final QpackEncoder encoder;
    private final boolean useDirectByteBuffers;

    public HeadersGenerator(ByteBufferPool bufferPool, QpackEncoder encoder, boolean useDirectByteBuffers) {
        super(bufferPool);
        this.encoder = encoder;
        this.useDirectByteBuffers = useDirectByteBuffers;
    }

    @Override
    public int generate(ByteBufferPool.Accumulator accumulator, long streamId, Frame frame, Consumer<Throwable> fail) {
        HeadersFrame headersFrame = (HeadersFrame)frame;
        return this.generateHeadersFrame(accumulator, streamId, headersFrame, fail);
    }

    private int generateHeadersFrame(ByteBufferPool.Accumulator accumulator, long streamId, HeadersFrame frame, Consumer<Throwable> fail) {
        try {
            int frameTypeLength = VarLenInt.length(FrameType.HEADERS.type());
            int maxHeaderLength = frameTypeLength + 8;
            int maxLength = this.encoder.getMaxHeadersSize();
            RetainableByteBuffer buffer = this.getByteBufferPool().acquire(maxHeaderLength + maxLength, this.useDirectByteBuffers);
            accumulator.append(buffer);
            ByteBuffer byteBuffer = buffer.getByteBuffer();
            BufferUtil.clearToFill((ByteBuffer)byteBuffer);
            byteBuffer.position(maxHeaderLength);
            byteBuffer.limit(byteBuffer.position() + maxLength);
            this.encoder.encode(byteBuffer, streamId, frame.getMetaData());
            byteBuffer.flip();
            byteBuffer.position(maxHeaderLength);
            int dataLength = buffer.remaining();
            int headerLength = frameTypeLength + VarLenInt.length(dataLength);
            int position = byteBuffer.position() - headerLength;
            byteBuffer.position(position);
            VarLenInt.encode(byteBuffer, FrameType.HEADERS.type());
            VarLenInt.encode(byteBuffer, dataLength);
            byteBuffer.position(position);
            return headerLength + dataLength;
        }
        catch (QpackException x) {
            if (fail != null) {
                fail.accept(x);
            }
            return -1;
        }
    }
}

