/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.websocket.javax.common.messages;

import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.List;
import javax.websocket.CloseReason;
import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import org.eclipse.jetty.ee8.websocket.javax.common.JavaxWebSocketFrameHandlerFactory;
import org.eclipse.jetty.ee8.websocket.javax.common.decoders.RegisteredDecoder;
import org.eclipse.jetty.ee8.websocket.javax.common.messages.AbstractDecodedMessageSink;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.exception.CloseException;
import org.eclipse.jetty.websocket.core.messages.MessageSink;
import org.eclipse.jetty.websocket.core.messages.ReaderMessageSink;

public class DecodedTextStreamMessageSink<T>
extends AbstractDecodedMessageSink.Stream<Decoder.TextStream<T>> {
    public DecodedTextStreamMessageSink(CoreSession session, MethodHandle methodHandle, List<RegisteredDecoder> decoders) {
        super(session, methodHandle, decoders);
    }

    @Override
    MessageSink newMessageSink(CoreSession coreSession) throws Exception {
        MethodHandle methodHandle = JavaxWebSocketFrameHandlerFactory.getServerMethodHandleLookup().findVirtual(DecodedTextStreamMessageSink.class, "onStreamStart", MethodType.methodType(Void.TYPE, Reader.class)).bindTo(this);
        return new ReaderMessageSink(coreSession, methodHandle, true);
    }

    public void onStreamStart(Reader reader) {
        try {
            Object obj = ((Decoder.TextStream)this._decoder).decode(reader);
            this.invoke(obj);
        }
        catch (IOException | DecodeException e) {
            throw new CloseException(CloseReason.CloseCodes.CANNOT_ACCEPT.getCode(), "Unable to decode", e);
        }
    }
}

